/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.sequence;

import com.bysquare.document.BysquareDocument;
import com.bysquare.sequence.BadFormatException;
import com.bysquare.sequence.InvoiceBaseEncoder;
import com.bysquare.sequence.InvoiceItemsBaseEncoder;
import com.bysquare.sequence.PayBaseEncoder;
import com.bysquare.sequence.SequenceLimitExceededException;
import com.bysquare.sequence.Truncation;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceEncoder {
    public static final int DEFAULT_LIMIT = 550;
    public static final int DEFAULT_MAXPRIORITY = 0;
    private final SimpleDateFormat dateFormat;
    private final DecimalFormat decimalFormat;
    private int limit = 550;
    private int maxPriority = Integer.MAX_VALUE;
    private boolean truncated;
    private String[] fields;
    private int index;
    private PriorityQueue<Truncation> truncations;

    private static char[] getChars(String[] stringArray) {
        char[] cArray = new char[SequenceEncoder.getLength(stringArray)];
        int n = 0;
        boolean bl = false;
        for (String string : stringArray) {
            if (bl) {
                cArray[n++] = 9;
            }
            if (string != null) {
                string.getChars(0, string.length(), cArray, n);
                n += string.length();
            }
            bl = true;
        }
        return cArray;
    }

    public static SequenceEncoder getInstance(int n) {
        switch (n) {
            case 0: {
                return new PayBaseEncoder();
            }
            case 1: {
                return new InvoiceBaseEncoder();
            }
            case 2: {
                return new InvoiceItemsBaseEncoder();
            }
        }
        return null;
    }

    private static int getLength(String[] stringArray) {
        int n = stringArray.length - 1;
        for (String string : stringArray) {
            if (string == null) continue;
            n += string.length();
        }
        return n;
    }

    SequenceEncoder() {
        this.decimalFormat = new DecimalFormat("#.########", new DecimalFormatSymbols(Locale.US));
        this.dateFormat = new SimpleDateFormat("yyyyMMdd");
        this.dateFormat.setLenient(false);
    }

    protected void add(Date date) {
        if (date != null) {
            this.addInternal(this.dateFormat.format(date));
        } else {
            this.skip();
        }
    }

    protected void add(Double d) {
        if (d != null) {
            this.addInternal(this.decimalFormat.format(d));
        } else {
            this.skip();
        }
    }

    protected <E extends Enum<E>> void add(E e) {
        if (e != null) {
            this.addInternal(Integer.toString(e.ordinal()));
        } else {
            this.skip();
        }
    }

    protected void add(int n) {
        this.addInternal(Integer.toString(n));
    }

    protected void add(Integer n) {
        if (n != null) {
            this.addInternal(Integer.toString(n));
        } else {
            this.skip();
        }
    }

    protected <E extends Enum<E>> void add(List<E> list) {
        if (list != null && !list.isEmpty()) {
            int n = 0;
            for (Enum enum_ : list) {
                n |= 1 << enum_.ordinal();
            }
            if (n != 0) {
                this.addInternal(Integer.toString(n));
            } else {
                this.skip();
            }
        } else {
            this.skip();
        }
    }

    protected void add(String string) {
        if (string != null) {
            this.addInternal(string.replace('\t', ' '));
        } else {
            this.skip();
        }
    }

    protected void add(String string, int n, int n2) {
        if (string != null) {
            this.truncations.add(new Truncation(this.index, n, n2));
            this.addInternal(string.replace('\t', ' '));
        } else {
            this.skip();
        }
    }

    private void addInternal(String string) {
        this.fields[this.index++] = string;
    }

    public String encode(BysquareDocument bysquareDocument) throws BadFormatException {
        this.index = 0;
        this.truncated = false;
        int n = this.getFieldCount(bysquareDocument);
        this.fields = new String[n];
        this.truncations = new PriorityQueue();
        try {
            this.encodeInternal(bysquareDocument);
            if (this.limit > 0) {
                this.truncate();
            }
            String string = new String(SequenceEncoder.getChars(this.fields));
            return string;
        }
        catch (BadFormatException badFormatException) {
            throw badFormatException;
        }
        catch (Throwable throwable) {
            throw new BadFormatException(throwable);
        }
        finally {
            this.fields = null;
            this.truncations = null;
        }
    }

    protected abstract void encodeInternal(BysquareDocument var1);

    protected abstract int getFieldCount(BysquareDocument var1);

    public void setLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Sequence limit cannot be negative.");
        }
        this.limit = n;
    }

    public void setMaxPriority(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Maximum priority cannot be negative.");
        }
        this.maxPriority = n;
    }

    protected void skip() {
        ++this.index;
    }

    private void truncate() throws SequenceLimitExceededException {
        int n = SequenceEncoder.getLength(this.fields);
        while (n > this.limit) {
            String string;
            Truncation truncation = this.truncations.poll();
            if (truncation == null || truncation.priority >= this.maxPriority) {
                string = "Data length (%s) exceeds the limit (%s).";
                String string2 = String.format(string, n, this.limit);
                throw new SequenceLimitExceededException(string2);
            }
            string = this.fields[truncation.index];
            if (string.length() <= truncation.maxLength) continue;
            int n2 = Math.min(string.length() - truncation.maxLength, n - this.limit);
            this.fields[truncation.index] = string.substring(0, string.length() - n2);
            n -= n2;
            this.truncated = true;
        }
    }

    public final boolean wasTruncated() {
        return this.truncated;
    }
}

